#if !defined( _POINTLIGHTS_FXH )
#define _POINTLIGHTS_FXH

//---------------------------------------------------------------------------------
//
// Macros and definitions for point lighting.
//

#define DECLARE_POINT_PARAMS( __count__ )							\
float3 lightPosition##__count__ : lightPosition				\
<																											\
	bool appEdit = false;																\
>;																										\
float4 lightColour##__count__ : lightColour						\
<																											\
	bool appEdit = false;																\
>;																										\
float lightAttenuation##__count__ : lightAttenuation	\
<																											\
	bool appEdit = false;																\
>;

#define DECLARE_POINT_INTERPOLATORS( __index__, __count__ )


#define DO_VS_POINT_LIGHTING_SETUP


#define DO_VS_POINT_LIGHTING_CALCULATIONS( __count__ )


#if defined( USE_TRANSMISSIVE_LIGHTING )

#define DO_PS_POINT_LIGHTING_SETUP	\
	LPFLOAT3 PSPOINT_lightVector;			\
	LPFLOAT PSPOINT_diffuseLevel;			\
	LPFLOAT PSPOINT_transLevel;

#else

#define DO_PS_POINT_LIGHTING_SETUP	\
	LPFLOAT3 PSPOINT_lightVector;			\
	LPFLOAT PSPOINT_diffuseLevel;

#endif


#if defined( USE_WARD_ANISOTROPIC_SPECULAR )

//
// Ward-style anisotropic lighting version
//
#define DO_PS_POINT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSPOINT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculatePointLightAttenuation( PSPOINT_lightVector,															\
																										 lightAttenuation##__count__ );										\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSPOINT_lightVector = normalize( PSPOINT_lightVector );																							\
																																																			\
	PSPOINT_diffuseLevel = CalculateDiffuseLighting( normal, PSPOINT_lightVector );											\
	__accumulator__ += diffuseTexColour * max( PSPOINT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSPOINT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		__accumulator__ += specularTexColour *																														\
											 CalculateWardSpecularLighting( normal, perturbedUAxis, perturbedVAxis, alphaXValue, alphaYValue, PSPOINT_lightVector, eye ) *	\
											 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;								\
	}

#elif defined( USE_TRANSMISSIVE_LIGHTING )

//
// Blinn-style + transmissive lighting version
//
#define DO_PS_POINT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSPOINT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculatePointLightAttenuation( PSPOINT_lightVector,															\
																										 lightAttenuation##__count__ );										\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSPOINT_lightVector = normalize( PSPOINT_lightVector );																							\
																																																			\
	PSPOINT_diffuseLevel = CalculateDiffuseLighting( normal, PSPOINT_lightVector );											\
	__accumulator__ += diffuseTexColour * max( PSPOINT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	PSPOINT_transLevel = CalculateDiffuseLighting( -normal, PSPOINT_lightVector );											\
	__accumulator__ += transmissiveTexColour * max( PSPOINT_transLevel, 0.0f ) *												\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSPOINT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );										\
		__accumulator__ += specularTexColour *																														\
											 CalculateSpecularLighting( normal,																							\
																									PSPOINT_lightVector,																\
																									eye,																								\
																									specularPower ) *																		\
											 lightColour##__count__ *																												\
											 globalSpecularFactorValue *																													\
											 PSL_attenuation;																																\
	}

#else

//
// Blinn-style lighting version
//
#define DO_PS_POINT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSPOINT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculatePointLightAttenuation( PSPOINT_lightVector,															\
																										 lightAttenuation##__count__ );										\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSPOINT_lightVector = normalize( PSPOINT_lightVector );																							\
																																																			\
	PSPOINT_diffuseLevel = CalculateDiffuseLighting( normal, PSPOINT_lightVector );											\
	__accumulator__ += diffuseTexColour * max( PSPOINT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSPOINT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );										\
		__accumulator__ += specularTexColour *																														\
											 CalculateSpecularLighting( normal,																							\
																									PSPOINT_lightVector,																\
																									eye,																								\
																									specularPower ) *																		\
											 lightColour##__count__ *																												\
											 globalSpecularFactorValue *																													\
											 PSL_attenuation;																																\
	}

#endif	// defined( USE_WARD_ANISOTROPIC_SPECULAR )

#endif	// !defined( _POINTLIGHTS_FXH )
